/*
 * EXPORT CONTROLLED - This technology or software is subject to the U.S. Export
 * Administration Regulations (EAR), (15 C.F.R. Parts 730-774). No authorization
 * from the U.S. Department of Commerce is required for export, re-export, in-
 * country transfer, or access EXCEPT to country group E:1 or E:2 countries/
 * persons per Supp. 1 to Part 740 of the EAR.
*/

/*
 * Copyright © 2011,2021 Liquid Robotics, Inc., confidential and
 * proprietary. All rights reserved.
 */

package com.liquidr.dataservice;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;

/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.8
 * Generated source version: 2.2
 * 
 */
@WebService(name = "WGMSDataSoap", targetNamespace = "https://wds.wgms.com/")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface WGMSDataSoap {


    /**
     * 
     * @return returns java.lang.String
     */
    @WebMethod(operationName = "SystemCheck", action = "https://wds.wgms.com/SystemCheck")
    @WebResult(name = "SystemCheckResult", targetNamespace = "https://wds.wgms.com/")
    @RequestWrapper(localName = "SystemCheck", targetNamespace = "https://wds.wgms.com/", className = "SystemCheck")
    @ResponseWrapper(localName = "SystemCheckResponse", targetNamespace = "https://wds.wgms.com/", className = "SystemCheckResponse")
    public String systemCheck();

    /**
     * @param token
     * @param resultFormat
     * @return returns java.lang.String
     */
    @WebMethod(operationName = "GetReportList", action = "https://wds.wgms.com/GetReportList")
    @WebResult(name = "GetReportListResult", targetNamespace = "https://wds.wgms.com/")
    @RequestWrapper(localName = "GetReportList", targetNamespace = "https://wds.wgms.com/", className = "GetReportList")
    @ResponseWrapper(localName = "GetReportListResponse", targetNamespace = "https://wds.wgms.com/", className = "GetReportListResponse")
    public String getReportList(
        @WebParam(name = "token", targetNamespace = "https://wds.wgms.com/")
        String token,
        @WebParam(name = "ResultFormat", targetNamespace = "https://wds.wgms.com/")
        int resultFormat);

    /**
     * 
     * @param token
     * @param reportName
     * @param resultFormat
     * @return returns java.lang.String
     */
    @WebMethod(operationName = "GetReport_Details_ByName", action = "https://wds.wgms.com/GetReport_Details_ByName")
    @WebResult(name = "GetReport_Details_ByNameResult", targetNamespace = "https://wds.wgms.com/")
    @RequestWrapper(localName = "GetReport_Details_ByName", targetNamespace = "https://wds.wgms.com/", className = "GetReportDetailsByName")
    @ResponseWrapper(localName = "GetReport_Details_ByNameResponse", targetNamespace = "https://wds.wgms.com/", className = "GetReportDetailsByNameResponse")
    public String getReportDetailsByName(
        @WebParam(name = "Token", targetNamespace = "https://wds.wgms.com/")
        String token,
        @WebParam(name = "ReportName", targetNamespace = "https://wds.wgms.com/")
        String reportName,
        @WebParam(name = "ResultFormat", targetNamespace = "https://wds.wgms.com/")
        int resultFormat);

    /**
     * 
     * @param token
     * @param reportName
     * @param resultFormat
     * @return returns java.lang.String
     */
    @WebMethod(operationName = "GetReport_MetaData_ByName", action = "https://wds.wgms.com/GetReport_MetaData_ByName")
    @WebResult(name = "GetReport_MetaData_ByNameResult", targetNamespace = "https://wds.wgms.com/")
    @RequestWrapper(localName = "GetReport_MetaData_ByName", targetNamespace = "https://wds.wgms.com/", className = "GetReportMetaDataByName")
    @ResponseWrapper(localName = "GetReport_MetaData_ByNameResponse", targetNamespace = "https://wds.wgms.com/", className = "GetReportMetaDataByNameResponse")
    public String getReportMetaDataByName(
        @WebParam(name = "Token", targetNamespace = "https://wds.wgms.com/")
        String token,
        @WebParam(name = "ReportName", targetNamespace = "https://wds.wgms.com/")
        String reportName,
        @WebParam(name = "ResultFormat", targetNamespace = "https://wds.wgms.com/")
        int resultFormat);

    /**
     * 
     * @param token
     * @param resultFormat
     * @return returns java.lang.String
     */
    @WebMethod(operationName = "GetGliderList", action = "https://wds.wgms.com/GetGliderList")
    @WebResult(name = "GetGliderListResult", targetNamespace = "https://wds.wgms.com/")
    @RequestWrapper(localName = "GetGliderList", targetNamespace = "https://wds.wgms.com/", className = "GetGliderList")
    @ResponseWrapper(localName = "GetGliderListResponse", targetNamespace = "https://wds.wgms.com/", className = "GetGliderListResponse")
    public String getGliderList(
        @WebParam(name = "Token", targetNamespace = "https://wds.wgms.com/")
        String token,
        @WebParam(name = "ResultFormat", targetNamespace = "https://wds.wgms.com/")
        int resultFormat);

    /**
     * 
     * @param token
     * @param reportName
     * @param endDate
     * @param resultFormat
     * @param startDate
     * @param serialNo
     * @return returns java.lang.String
     */
    @WebMethod(operationName = "GetReportData", action = "https://wds.wgms.com/GetReportData")
    @WebResult(name = "GetReportDataResult", targetNamespace = "https://wds.wgms.com/")
    @RequestWrapper(localName = "GetReportData", targetNamespace = "https://wds.wgms.com/", className = "GetReportData")
    @ResponseWrapper(localName = "GetReportDataResponse", targetNamespace = "https://wds.wgms.com/", className = "GetReportDataResponse")
    public String getReportData(
        @WebParam(name = "Token", targetNamespace = "https://wds.wgms.com/")
        String token,
        @WebParam(name = "ReportName", targetNamespace = "https://wds.wgms.com/")
        String reportName,
        @WebParam(name = "SerialNo", targetNamespace = "https://wds.wgms.com/") 
        String serialNo,
        @WebParam(name = "StartDate", targetNamespace = "https://wds.wgms.com/")
        XMLGregorianCalendar startDate,
        @WebParam(name = "EndDate", targetNamespace = "https://wds.wgms.com/")
        XMLGregorianCalendar endDate,
        @WebParam(name = "ResultFormat", targetNamespace = "https://wds.wgms.com/")
        int resultFormat);

}
